<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;

Route::post('/login', [AuthController::class, 'login']);

Route::middleware(['auth:sanctum'])->group(function () {
    Route::apiResource('users', UserController::class);
    Route::apiResource('roles', \App\Http\Controllers\RoleController::class);
    Route::apiResource('sucursales', \App\Http\Controllers\SucursalController::class);
    Route::apiResource('productos', \App\Http\Controllers\ProductoController::class);
    Route::get('familias/stats', [\App\Http\Controllers\FamiliaController::class, 'stats']);
    Route::apiResource('familias', \App\Http\Controllers\FamiliaController::class);
    Route::apiResource('miembros', \App\Http\Controllers\MiembroFamiliaController::class);
    Route::get('permissions', [\App\Http\Controllers\PermissionController::class, 'index']);
    
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
});
