<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            // Principal
            ['categoria' => 'Principal', 'nombre' => 'Ver Dashboard', 'slug' => 'ver_dashboard'],
            
            // Ventas
            ['categoria' => 'Ventas', 'nombre' => 'Punto de Venta', 'slug' => 'punto_venta'],
            ['categoria' => 'Ventas', 'nombre' => 'Ver Ventas', 'slug' => 'ver_ventas'],
            ['categoria' => 'Ventas', 'nombre' => 'Nueva Venta', 'slug' => 'nueva_venta'],

            // Inventarios
            ['categoria' => 'Inventarios', 'nombre' => 'Ver Inventario', 'slug' => 'ver_inventario'],
            ['categoria' => 'Inventarios', 'nombre' => 'Nuevo Producto', 'slug' => 'nuevo_producto'],
            ['categoria' => 'Inventarios', 'nombre' => 'Movimientos', 'slug' => 'movimientos'],

            // Administración
            ['categoria' => 'Administración', 'nombre' => 'Usuarios', 'slug' => 'usuarios'],
            ['categoria' => 'Administración', 'nombre' => 'Roles', 'slug' => 'roles'],
            ['categoria' => 'Administración', 'nombre' => 'Reportes', 'slug' => 'reportes'],
            ['categoria' => 'Administración', 'nombre' => 'Configuración', 'slug' => 'configuracion'],

            // Sistema
            ['categoria' => 'Sistema', 'nombre' => 'Logs', 'slug' => 'logs'],
            ['categoria' => 'Sistema', 'nombre' => 'Backups', 'slug' => 'backups'],
        ];

        foreach ($permissions as $permission) {
            \App\Models\Permission::create($permission);
        }
    }
}
