<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('familias', function (Blueprint $table) {
            $table->id();
            $table->string('identificador')->unique(); // FAM-#######
            $table->string('nombre');    // Nombre del titular o principal
            $table->string('apellidos')->nullable();
            $table->string('telefono');
            $table->string('address')->nullable();
            $table->string('email');
            $table->string('foto')->nullable(); // URL de la foto
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('familias');
    }
};
