<?php

namespace App\Http\Controllers;

abstract class Controller
{
    /**
     * Guarda una imagen en Base64 y retorna la URL pública.
     *
     * @param string $base64Image
     * @param string $folder
     * @return string|null
     */
    protected function saveBase64Image($base64Image, $folder = 'images')
    {
        if (!$base64Image) {
            return null;
        }

        // Si ya es una URL (http...), la devolvemos tal cual (para actualizaciones donde no cambia la foto)
        if (filter_var($base64Image, FILTER_VALIDATE_URL)) {
            return $base64Image;
        }

        // Extraer el tipo de imagen y la data
        if (preg_match('/^data:image\/(\w+);base64,/', $base64Image, $type)) {
            $base64Image = substr($base64Image, strpos($base64Image, ',') + 1);
            $type = strtolower($type[1]); // jpg, png, gif

            if (!in_array($type, ['jpg', 'jpeg', 'gif', 'png'])) {
                return null; // O lanzar excepción
            }

            $base64Image = str_replace(' ', '+', $base64Image);
            $imageName = \Illuminate\Support\Str::random(10) . '.' . $type;
            
            // Usar Storage facade
            \Illuminate\Support\Facades\Storage::disk('public')->put($folder . '/' . $imageName, base64_decode($base64Image));

            // Retornar la URL completa
            return url('storage/' . $folder . '/' . $imageName);
        }

        return null;
    }
}
