<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'usuario' => 'required|string',
            'contrasena' => 'required|string',
        ]);

        $user = User::where('usuario', $request->usuario)->first();

        if (! $user || ! Hash::check($request->contrasena, $user->contrasena)) {
            return response()->json([
                'message' => 'Credenciales incorrectas'
            ], 401);
        }

        if ($user->status !== 'activo') {
            return response()->json([
                'message' => 'El usuario está desactivado'
            ], 403);
        }

        $token = $user->createToken('api_token')->plainTextToken;

        $user->load('role.permissions');

        return response()->json([
            'message' => 'Login exitoso',
            'access_token' => $token,
            'token_type' => 'Bearer',
            'user' => $user,
            'permissions' => $user->role ? $user->role->permissions : []
        ]);
    }
}
